#include "bitmap.h"
#include "pixel.h"
#include "types.h"
#include <iostream>
#include <fstream>
using namespace std;


Bitmap::Bitmap()
	:	myFileType(0),
		myBitCount(0),
		myStartBuffer(0),
		myWidth(0),
		myHeight(0),
		myCompressionType(0),
		myImageBuffer(NULL)
{

}

Bitmap::Bitmap(const char * fileName)
	:	myFileType(0),
		myBitCount(0),
		myStartBuffer(0),
		myWidth(0),
		myHeight(0),
		myCompressionType(0),
		myImageBuffer(NULL)
{
	loadBitmap(fileName);
}


Bitmap::~Bitmap()
{
	delete [] myImageBuffer;
}

// returns 0 if failed, 1 if succeded
bool Bitmap::loadBitmap(const char * fileName)
{
	ifstream BitmapStreamIn;
	UInt8 * pBuffer = NULL;

	BitmapStreamIn.open(fileName, ios::binary);

	if(BitmapStreamIn)
	{
		BitmapStreamIn.read( (char*) &myFileType, sizeof(UInt16) );
		if(BITMAP_FILE != myFileType) 
		{
			cout << "Invalid file type. Must be a BMP file." << endl;
			return 0;
		}
	
		// skip the next 8 bytes
		BitmapStreamIn.seekg(8,ios::cur);	

		// get the position of the start of the bitmap buffer
		BitmapStreamIn.read( (char*) &myStartBuffer, sizeof(UInt32) );

		// skip the next 4 bytes
		BitmapStreamIn.seekg(4,ios::cur);
	
		// get the width and height of the bitmap
		BitmapStreamIn.read( (char*) &myWidth, sizeof(UInt32) );
		BitmapStreamIn.read( (char*) &myHeight, sizeof(UInt32) );

		if(myWidth != 32 || myHeight != 32)
		{
			cout << "Invalid size of BMP file." << endl;
			return 0;
		}

		// skip the next 2 bytes
		BitmapStreamIn.seekg(2,ios::cur);

		// get the bit count
		BitmapStreamIn.read( (char*) &myBitCount, sizeof(UInt16) );

		if(myBitCount != BITMAP_BIT_COUNT)
		{
			cout << "Invalid bit count. Must be 24 bit." << endl;
			return 0;
		}

		// get compression type
		BitmapStreamIn.read( (char*) &myCompressionType, sizeof(UInt32) );

		// move to bitmap buffer
		BitmapStreamIn.seekg(myStartBuffer,ios::beg);

		// read image buffer from file
		pBuffer = new UInt8[myWidth * myHeight * 3];
		BitmapStreamIn.read( (char*) pBuffer, myWidth * myHeight * 3 * sizeof(UInt8) );

		if(NULL != myImageBuffer)
		{
			delete [] myImageBuffer;
		}

		myImageBuffer = new Pixel [myWidth * myHeight];

		for(int y=0;y<myHeight;y++)
		{
			for(int x=0;x<myWidth;x++)
			{
				// needs to be flipped
				if(myHeight > 0)
				{
					myImageBuffer[x + (myHeight - 1 - y) * (myWidth)] = Pixel( 255 |
						(pBuffer[(x + y * (myWidth)) * 3 + 0] << 8 ) |
						(pBuffer[(x + y * (myWidth)) * 3 + 1] << 16) |
						(pBuffer[(x + y * (myWidth)) * 3 + 2] << 24) );
				}
				// doesn't need to be flipped
				else
				{
					myImageBuffer[x + (y * myWidth)] = Pixel( 255 |
						(pBuffer[(x + y * (myWidth)) * 3 + 0] << 8 ) |
						(pBuffer[(x + y * (myWidth)) * 3 + 1] << 16) |
						(pBuffer[(x + y * (myWidth)) * 3 + 2] << 24) );
				}
			}
		}

	}
	else
	{
		return 0;
	}

	BitmapStreamIn.close();
	delete [] pBuffer;
	return 1;
}

